<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;

class MigrateProjectCertificate extends BaseCommand
{
    protected $group       = 'Database';
    protected $name        = 'migrate:project-certificate';
    protected $description = 'Migrate project and certificate data to database';

    public function run(array $params)
    {
        CLI::write('🚀 Starting Project & Certificate Data Migration...', 'green');
        CLI::newLine();

        try {
            // Run the seeder
            $seeder = \Config\Database::seeder();
            $seeder->call('ProjectCertificateSeederSimple');

            CLI::newLine();
            CLI::write('✅ Migration completed successfully!', 'green');
            CLI::write('📝 All project and certificate data has been inserted into the database.', 'yellow');
            CLI::newLine();

        } catch (\Exception $e) {
            CLI::error('❌ Migration failed: ' . $e->getMessage());
            CLI::newLine();
        }
    }
}